/*
 * Decompiled with CFR 0.152.
 */
package technology.rocketjump.undermount.mapping.model;

import com.badlogic.gdx.math.GridPoint2;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Array;
import java.util.EnumMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import technology.rocketjump.undermount.assets.model.FloorType;
import technology.rocketjump.undermount.assets.model.GameMaterial;
import technology.rocketjump.undermount.mapping.model.MapEnvironment;
import technology.rocketjump.undermount.mapping.tile.CompassDirection;
import technology.rocketjump.undermount.mapping.tile.MapTile;
import technology.rocketjump.undermount.mapping.tile.MapVertex;
import technology.rocketjump.undermount.mapping.tile.TileNeighbours;
import technology.rocketjump.undermount.rooms.Room;

public class TiledMap {
    private final int width;
    private final int height;
    private Array<Array<MapTile>> cells;
    private Array<Array<MapVertex>> mapVertices;
    private final MapEnvironment environment = new MapEnvironment();
    private final Map<Long, Room> rooms = new ConcurrentHashMap<Long, Room>();
    private GridPoint2 embarkPoint;
    private static final List<CompassDirection> orthogonalDirections = new LinkedList<CompassDirection>();

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public TiledMap(long seed, int width, int height, FloorType baseFloor, GameMaterial baseFloorMaterial) {
        this.width = width;
        this.height = height;
        this.cells = new Array(width);
        this.mapVertices = new Array(width + 1);
        Random random = new Random(seed);
        for (int x = 0; x < width; ++x) {
            Array<MapTile> column = new Array<MapTile>(height);
            Array<MapVertex> vertexColumn = new Array<MapVertex>(height + 1);
            for (int y = 0; y < height; ++y) {
                column.add(new MapTile(random.nextLong(), x, y, baseFloor, baseFloorMaterial));
                vertexColumn.add(new MapVertex(x, y));
            }
            vertexColumn.add(new MapVertex(x, height));
            this.cells.add(column);
            this.mapVertices.add(vertexColumn);
        }
        Array<MapVertex> vertexColumn = new Array<MapVertex>(height + 1);
        for (int y = 0; y < height + 1; ++y) {
            vertexColumn.add(new MapVertex(width, y));
        }
        this.mapVertices.add(vertexColumn);
    }

    public MapTile getTile(int tileX, int tileY) {
        if (tileX < 0 || tileX >= this.width) {
            return null;
        }
        if (tileY < 0 || tileY >= this.height) {
            return null;
        }
        return this.cells.get(tileX).get(tileY);
    }

    public TileNeighbours getNeighbours(GridPoint2 location) {
        return this.getNeighbours(location.x, location.y);
    }

    public TileNeighbours getNeighbours(int x, int y) {
        TileNeighbours neighbours = new TileNeighbours();
        for (CompassDirection direction : CompassDirection.values()) {
            MapTile cellInDirection = this.getTile(x + direction.getXOffset(), y + direction.getYOffset());
            if (cellInDirection == null) continue;
            neighbours.put(direction, cellInDirection);
        }
        return neighbours;
    }

    public TileNeighbours getOrthogonalNeighbours(int x, int y) {
        TileNeighbours neighbours = new TileNeighbours();
        for (CompassDirection direction : orthogonalDirections) {
            MapTile cellInDirection = this.getTile(x + direction.getXOffset(), y + direction.getYOffset());
            if (cellInDirection == null) continue;
            neighbours.put(direction, cellInDirection);
        }
        return neighbours;
    }

    public MapTile getTile(MapVertex vertex, CompassDirection cellDirectionFromVertex) {
        if (cellDirectionFromVertex.equals((Object)CompassDirection.SOUTH_WEST)) {
            return this.getTile(vertex.getVertexX() - 1, vertex.getVertexY() - 1);
        }
        if (cellDirectionFromVertex.equals((Object)CompassDirection.NORTH_WEST)) {
            return this.getTile(vertex.getVertexX() - 1, vertex.getVertexY());
        }
        if (cellDirectionFromVertex.equals((Object)CompassDirection.NORTH_EAST)) {
            return this.getTile(vertex.getVertexX(), vertex.getVertexY());
        }
        if (cellDirectionFromVertex.equals((Object)CompassDirection.SOUTH_EAST)) {
            return this.getTile(vertex.getVertexX(), vertex.getVertexY() - 1);
        }
        throw new IllegalArgumentException((Object)((Object)cellDirectionFromVertex) + " does not make sense for a tile to access from vertex (" + vertex.getVertexX() + ", " + vertex.getVertexY());
    }

    public MapVertex getVertex(int vertexX, int vertexY) {
        return this.mapVertices.get(vertexX).get(vertexY);
    }

    public MapVertex getVertex(MapTile cell, CompassDirection vertexDirectionFromCell) {
        if (vertexDirectionFromCell.equals((Object)CompassDirection.SOUTH_WEST)) {
            return this.getVertex(cell.getTileX(), cell.getTileY());
        }
        if (vertexDirectionFromCell.equals((Object)CompassDirection.NORTH_WEST)) {
            return this.getVertex(cell.getTileX(), cell.getTileY() + 1);
        }
        if (vertexDirectionFromCell.equals((Object)CompassDirection.NORTH_EAST)) {
            return this.getVertex(cell.getTileX() + 1, cell.getTileY() + 1);
        }
        if (vertexDirectionFromCell.equals((Object)CompassDirection.SOUTH_EAST)) {
            return this.getVertex(cell.getTileX() + 1, cell.getTileY());
        }
        throw new IllegalArgumentException((Object)((Object)vertexDirectionFromCell) + " does not make sense for a vertex to access from tile (" + cell.getTileX() + ", " + cell.getTileY());
    }

    public MapVertex[] getVertices(int tileX, int tileY) {
        return new MapVertex[]{this.getVertex(tileX, tileY), this.getVertex(tileX, tileY + 1), this.getVertex(tileX + 1, tileY + 1), this.getVertex(tileX + 1, tileY)};
    }

    public TileNeighbours getTileNeighboursOfVertex(MapVertex vertex) {
        TileNeighbours neighbours = new TileNeighbours();
        neighbours.put(CompassDirection.NORTH_WEST, this.getTile(vertex.getVertexX(), vertex.getVertexY()));
        neighbours.put(CompassDirection.NORTH_EAST, this.getTile(vertex.getVertexX() - 1, vertex.getVertexY()));
        neighbours.put(CompassDirection.SOUTH_WEST, this.getTile(vertex.getVertexX() - 1, vertex.getVertexY() - 1));
        neighbours.put(CompassDirection.SOUTH_EAST, this.getTile(vertex.getVertexX(), vertex.getVertexY() - 1));
        return neighbours;
    }

    public EnumMap<CompassDirection, MapVertex> getVertexNeighboursOfCell(MapTile cell) {
        EnumMap<CompassDirection, MapVertex> neighbourVertices = new EnumMap<CompassDirection, MapVertex>(CompassDirection.class);
        neighbourVertices.put(CompassDirection.NORTH_WEST, this.getVertex(cell, CompassDirection.NORTH_WEST));
        neighbourVertices.put(CompassDirection.NORTH_EAST, this.getVertex(cell, CompassDirection.NORTH_EAST));
        neighbourVertices.put(CompassDirection.SOUTH_EAST, this.getVertex(cell, CompassDirection.SOUTH_EAST));
        neighbourVertices.put(CompassDirection.SOUTH_WEST, this.getVertex(cell, CompassDirection.SOUTH_WEST));
        return neighbourVertices;
    }

    public MapTile getTile(GridPoint2 tilePosition) {
        return this.getTile(tilePosition.x, tilePosition.y);
    }

    public MapTile getTile(Vector2 worldPosition) {
        return this.getTile(MathUtils.floor(worldPosition.x), MathUtils.floor(worldPosition.y));
    }

    public Array<MapTile> getNearestTiles(Vector2 worldPosition) {
        Array<MapTile> nearest = new Array<MapTile>(4);
        int worldTileX = MathUtils.floor(worldPosition.x);
        int worldTileY = MathUtils.floor(worldPosition.y);
        float subTileOffsetX = worldPosition.x - (float)worldTileX;
        float subTileOffsetY = worldPosition.y - (float)worldTileY;
        int xOffset = subTileOffsetX < 0.5f ? -1 : 1;
        int yOffset = subTileOffsetY < 0.5f ? -1 : 1;
        this.addTileTo(nearest, worldTileX, worldTileY);
        this.addTileTo(nearest, worldTileX + xOffset, worldTileY);
        this.addTileTo(nearest, worldTileX, worldTileY + yOffset);
        this.addTileTo(nearest, worldTileX + xOffset, worldTileY + yOffset);
        return nearest;
    }

    private void addTileTo(Array<MapTile> nearest, int tileX, int tileY) {
        MapTile cell = this.getTile(tileX, tileY);
        if (cell != null) {
            nearest.add(cell);
        }
    }

    public MapEnvironment getEnvironment() {
        return this.environment;
    }

    public Map<Long, Room> getRooms() {
        return this.rooms;
    }

    public Room getRoom(Long roomId) {
        return this.rooms.get(roomId);
    }

    public void removeRoom(Long roomId) {
        this.rooms.remove(roomId);
    }

    public GridPoint2 getEmbarkPoint() {
        return this.embarkPoint;
    }

    public void setEmbarkPoint(GridPoint2 embarkPoint) {
        this.embarkPoint = embarkPoint;
    }

    static {
        for (CompassDirection compassDirection : CompassDirection.values()) {
            if (compassDirection.isDiagonal()) continue;
            orthogonalDirections.add(compassDirection);
        }
    }
}

